<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Planification extends Model 
{

    protected $table = 'planifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function asset()
    {
        return $this->belongsTo('Asset');
    }

    public function maintenance_type()
    {
        return $this->belongsTo('MaintenanceType');
    }

    public function controle()
    {
        return $this->belongsToMany('Controle');
    }

    public function site()
    {
        return $this->belongsTo('Site');
    }

}